/***********************************************************************
 * emc_LPC18xx.c 
 *
 * Project: LPC18xx Common
 *
 * Description:
 *     Initialisation of the external memory interface for the 
 *     LPC18xx device series
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/
#include "LPC18xx.H"
#include "emc_LPC18xx.h"
#include "scu_LPC18xx.h"
#include "type.h"




/****************************************************************************************
* Set up the address/data pins for external memory interface in LPC43xx.
* Most of them are set already by the bootcode, or the reset state, but just to be 
* sure all of them are listed.
*
* These settings/modifications are allowed at runtime (note that this code runs
* from external memory), but there are other bits in the EMC registers which require
* to run this function from internal RAM.
* 
* 
****************************************************************************************/
void EMC_Config_Pinmux(void)
{

  // Data line configuration
  scu_pinmux(0x1,  7, MD_PLN, FUNC3);  // P1_7:   D0  
  scu_pinmux(0x1,  8, MD_PLN, FUNC3);  // P1_8:   D1  
  scu_pinmux(0x1,  9, MD_PLN, FUNC3);  // P1_9:   D2  
  scu_pinmux(0x1, 10, MD_PLN, FUNC3);  // P1_10:  D3  
  scu_pinmux(0x1, 11, MD_PLN, FUNC3);  // P1_11:  D4  
  scu_pinmux(0x1, 12, MD_PLN, FUNC3);  // P1_12:  D5  
  scu_pinmux(0x1, 13, MD_PLN, FUNC3);  // P1_13:  D6  
  scu_pinmux(0x1, 14, MD_PLN, FUNC3);  // P1_14:  D7  
  scu_pinmux(0x5,  4, MD_PLN, FUNC2);  // P5_4:   D8  
  scu_pinmux(0x5,  5, MD_PLN, FUNC2);  // P5_5:   D9  
  scu_pinmux(0x5,  6, MD_PLN, FUNC2);  // P5_6:   D10  
  scu_pinmux(0x5,  7, MD_PLN, FUNC2);  // P5_7:  D11  
  scu_pinmux(0x5,  0, MD_PLN, FUNC2);  // P5_0:  D12  
  scu_pinmux(0x5,  1, MD_PLN, FUNC2);  // P5_1:  D13  
  scu_pinmux(0x5,  2, MD_PLN, FUNC2);  // P5_2:  D14  
  scu_pinmux(0x5,  3, MD_PLN, FUNC2);  // P5_3:  D15  
  scu_pinmux(0xD,  2, MD_PLN, FUNC2);  // PD_2:  D16  
  scu_pinmux(0xD,  3, MD_PLN, FUNC2);  // PD_3:  D17  
  scu_pinmux(0xD,  4, MD_PLN, FUNC2);  // PD_4:  D18  
  scu_pinmux(0xD,  5, MD_PLN, FUNC2);  // PD_5:  D19  
  scu_pinmux(0xD,  6, MD_PLN, FUNC2);  // PD_6:  D20  
  scu_pinmux(0xD,  7, MD_PLN, FUNC2);  // PD_7:  D21  
  scu_pinmux(0xD,  8, MD_PLN, FUNC2);  // PD_8:  D22  
  scu_pinmux(0xD,  9, MD_PLN, FUNC2);  // PD_9:  D23  
  scu_pinmux(0xE,  5, MD_PLN, FUNC3);  // PE_5:  D24  
  scu_pinmux(0xE,  6, MD_PLN, FUNC3);  // PE_6:  D25  
  scu_pinmux(0xE,  7, MD_PLN, FUNC3);  // PE_7:  D26  
  scu_pinmux(0xE,  8, MD_PLN, FUNC3);  // PE_8:  D27  
  scu_pinmux(0xE,  9, MD_PLN, FUNC3);  // PE_9:  D28  
  scu_pinmux(0xE, 10, MD_PLN, FUNC3);  // PE_10: D29  
  scu_pinmux(0xE, 11, MD_PLN, FUNC3);  // PE_11: D30  
  scu_pinmux(0xE, 12, MD_PLN, FUNC3);  // PE_12: D31  
  
  // Address line configuration
  scu_pinmux(0x2,  9, MD_PLN, FUNC3);  // P2_9: A0  
  scu_pinmux(0x2, 10, MD_PLN, FUNC3);  // P2_10: A1  
  scu_pinmux(0x2, 11, MD_PLN, FUNC3);  // P2_11: A2  
  scu_pinmux(0x2, 12, MD_PLN, FUNC3);  // P2_12: A3  
  scu_pinmux(0x2, 13, MD_PLN, FUNC3);  // P2_13: A4  
  scu_pinmux(0x1,  0, MD_PLN, FUNC2);  // P1_0: A5  
  scu_pinmux(0x1,  1, MD_PLN, FUNC2);  // P1_1: A6 
  scu_pinmux(0x1,  2, MD_PLN, FUNC2);  // P1_2: A7
  scu_pinmux(0x2,  8, MD_PLN, FUNC3);  // P2_8: A8 
  scu_pinmux(0x2,  7, MD_PLN, FUNC3);  // P2_7: A9  
  scu_pinmux(0x2,  6, MD_PLN, FUNC2);  // P2_6: A10
  scu_pinmux(0x2,  2, MD_PLN, FUNC2);  // P2_2: A11
  scu_pinmux(0x2,  1, MD_PLN, FUNC2);  // P2_0: A12
  scu_pinmux(0x2,  0, MD_PLN, FUNC2);  // P2_0: A13
  scu_pinmux(0x6,  8, MD_PLN, FUNC1);  // P6_8: A14
  scu_pinmux(0x6,  7, MD_PLN, FUNC1);  // P6_7: A15 
  scu_pinmux(0xD, 16, MD_PLN, FUNC2);  // PD_16: A16 
  scu_pinmux(0xD, 15, MD_PLN, FUNC2);  // PD_15: A17 
  scu_pinmux(0xE,  0, MD_PLN, FUNC3);  // PE_0: A18 
  scu_pinmux(0xE,  1, MD_PLN, FUNC3);  // PE_1: A19
  scu_pinmux(0xE,  2, MD_PLN, FUNC3);  // PE_2: A20
  scu_pinmux(0xE,  3, MD_PLN, FUNC3);  // PE_3: A21
  scu_pinmux(0xE,  4, MD_PLN, FUNC3);  // PE_4: A22   

  // Control signals for static memory
  scu_pinmux(0x1,  3, MD_PLN, FUNC3);  // P1_6: OE
  scu_pinmux(0x1,  6, MD_PLN, FUNC3);  // P1_6: WE  
  scu_pinmux(0x1,  5, MD_PLN, FUNC3);  // P1_5: CS0
  scu_pinmux(0x1,  4, MD_PLN, FUNC3);  // P1_5: BLS0
#ifdef HITEX_BOARD
  scu_pinmux(0xD, 12, MD_PLN, FUNC2);  // PD_12: CS2
  scu_pinmux(0xD, 13, MD_PLN, FUNC2);  // PD_13: BLS2
#endif

}



/****************************************************************************************
* Configure CS0 for 70ns 16-bit flash memory.
* Configure CS2 for 55ns 16-bit SRAM (Hitex board)
*
* The core can run on 120MHz with these settings.
* If other frequencies (or other memory devices) are used the waitstates must be adjusted.
*      
****************************************************************************************/
void EMC_Config_Static(void)
{
  
  // Configure CS0 for flash memory
  *(uint32_t *)0x40005200 = 0x00000081;      /* CS0: 16 bit = WE */
  *(uint32_t *)0x40005208 = 0x00000000;      /* CS0: WAITOEN = 0*/
  *(uint32_t *)0x4000520C = 0x00000006;      /* CS0: WAITRD = 6 */

#ifdef HITEX_BOARD
  // The Hitex board has external SRAM on CS2
  *(uint32_t *)0x40005240 = 0x00000081;      /* CS2: 16 bit = WE */
  *(uint32_t *)0x40005248 = 0x00000000;      /* CS2: WAITOEN = 0 */
  *(uint32_t *)0x4000524C = 0x00000006;      /* CS2: WAITRD = 6 */
#endif  
}

